' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.IO
Partial Class Controls_SelectImage
  Inherits System.Web.UI.UserControl
  Public Delegate Sub ImageFinalizedEventHandler(ByVal sender As System.Object, _
      ByVal e As FileHandlingEventArgs)
  Public Event ImageFinalized As ImageFinalizedEventHandler

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    ' Synchronizuj cig literalny w instrukcji z napisem na przycisku
    litFinishButtonText.Text = btnFinish.Text
  End Sub

  Protected Sub btnUpload_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpload.Click
    Dim myUploadHandler As Toolkit.UploadHandler
    myUploadHandler = New Toolkit.UploadHandler()
    myUploadHandler.GenerateUniqueFileName = True
    myUploadHandler.AllowedExtensions = "^.jpg|.gif|.png|.jpeg$"
    myUploadHandler.VirtualSavePath = AppConfiguration.TempImagesFolder
    Try
      myUploadHandler.UploadFile(FileUpload1)
    Catch aex As ArgumentException
      Select Case aex.ParamName.ToLower()
        Case "extension"
          lblIllegalExtension.Visible = True
        Case "filename"
          lblFileName.Visible = True
        Case "myfileupload"
          lblNoFile.Visible = True
      End Select
      Exit Sub
    Catch Ex As Exception
      lblErrorMessageUnknownError.Visible = False
      Exit Sub
    End Try

    Try
      FileName = Path.Combine(myUploadHandler.VirtualSavePath, _
           myUploadHandler.FileName) & myUploadHandler.Extension
      Toolkit.Imaging.ResizeImage(Server.MapPath(FileName), _
                  AppConfiguration.MaxImageWidth, AppConfiguration.MaxImageHeight)
      ' Dodaj logo do obrazu
      Toolkit.Imaging.AddLogoToImage(Server.MapPath(FileName), _
                Server.MapPath(FileName), Server.MapPath("~/Images/WroxLogo.gif"))
      imgUploaded.ImageUrl = FileName
      plcUpload.Visible = False
      plcImage.Visible = True

    Catch aex As ArgumentException
      ' ArgumentException jest rzucany kiedy plik przesany jako argument nie zawiera obrazka
      lblErrorMessageIllegalFile.Visible = True
    Catch Ex As Exception
      lblErrorMessageUnknownError.Visible = True
    End Try
  End Sub

  Protected Sub btnNewImage_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnNewImage.Click
    plcUpload.Visible = True
    plcImage.Visible = False
  End Sub

#Region "Waciwoci i metody wsplne dla wszystkich kontrolek uytkownika"

  Public Property FileName() As String
    Get
      If ViewState("FileName") IsNot Nothing Then
        Return ViewState("FileName").ToString()
      Else
        Return String.Empty
      End If
    End Get
    Private Set(ByVal value As String)
      ViewState("FileName") = value
    End Set
  End Property

  Public Property FinishButtonText() As String
    Get
      Return btnFinish.Text
    End Get
    Set(ByVal value As String)
      btnFinish.Text = value
      ' Aktualizuj cig znakowy nowym tekstem
      litFinishButtonText.Text = btnFinish.Text
    End Set
  End Property

  Protected Sub btnFinish_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnFinish.Click
    RaiseEvent ImageFinalized(Me, New FileHandlingEventArgs(FileName))
  End Sub

#End Region

End Class
